# Code for structural estimation (indirect inference) with schools of size between 4 and 150

# Import packages
import os, sys
import numpy as np
import pandas as pd
import pickle, math
import random 
from sklearn.linear_model import LinearRegression 
from sklearn.metrics import r2_score 
import scipy.optimize

# Define a function: an adjacency matrix to a vector of pairs
def adjpair_dir(A):
    N=A.shape[0]
    y=np.array([0])
    for k in range(1,N+1):
        a=np.concatenate((A[0:k-1,k-1],A[k:N+1,k-1]),axis=0)
        y=np.append(y,a,axis=0)
    return y[1:y.shape[0]+1] 

# Define a function to check eigenvector condition
def eigcons(p,Xcell1,Xcell2,D,ep):
    H=len(Xcell1)
    X1=Xcell1[0]
    beta0=p[0]
    K=X1.shape[2]
    beta=p[1:2*K+1]
    alpha=abs(p[2*K+1])
    R=100
    qm=np.zeros((H))
    sig2=abs(p[2*K+3])
    for h in range(1,H+1):
        X1=Xcell1[h-1]
        X2=Xcell2[h-1]
        N=X1.shape[0]
        Xarray1=np.zeros((N,N,K))
        Xarray2=np.zeros((N,N,K))
        for k in range(1,K+1):
            Xarray1[:,:,k-1]=X1[:,:,k-1]*beta[k-1]
            Xarray2[:,:,k-1]=X2[:,:,k-1]*beta[K+k-1]
        XB=np.sum(Xarray1,axis=2)+np.sum(Xarray2,axis=2)+(np.ones((N,N))-np.identity(N))*beta0
        Delta=D[h-1] 
        q=np.zeros((R))
        EP=ep[h-1]
        for r in range(1,101):
            ER=sig2*EP[:,:,r-1]
            B1=XB+ER
            a=np.amax(np.linalg.eig(B1)[0])
            if a==0:
                q[r-1]=-999
            else:
                q[r-1]=1/a-alpha/N
        qm[h-1]=np.amin(q)
    return np.amin(qm)

# Define the indirect inference objective function 
def socint_obj(p,Xcell1,Xcell2,SDcell,D,EPcell,mu,WA,xdata,ADcell): #,Lambda,LI1): 
    if eigcons(p,Xcell1,Xcell2,D,EPcell)>0:
        H=len(Xcell1)
        K=Xcell1[0].shape[2]
        beta0=p[0]
        beta=p[1:2*K+1]
        alpha=abs(p[2*K+1])
        c=abs(p[2*K+2])
        sig=abs(p[2*K+3])
        R=100
        mut=np.zeros((K+4,R))
        XBc=[]
        Ap=np.zeros((1))
        for h in range(1,H+1):
            N=Xcell1[h-1].shape[0]
            Xarray1=np.zeros((N,N,K))
            Xarray2=np.zeros((N,N,K))
            X1=Xcell1[h-1]
            X2=Xcell2[h-1]
            Ap1=adjpair_dir(ADcell[h-1])
            for k in range(1,K+1):
                Xarray1[:,:,k-1]=X1[:,:,k-1]*beta[k-1]
                Xarray2[:,:,k-1]=X2[:,:,k-1]*beta[K+k-1]
            XBc.append(np.sum(Xarray1,axis=2)+np.sum(Xarray2,axis=2)+(np.ones((N,N))-np.identity(N))*beta0)
            Ap=np.concatenate((Ap,Ap1),axis=0)
        App=Ap[1:Ap.shape[0]+1]
        AY=np.where(App>0)*1
        mut=np.zeros((2*K+4,R))
        xdataF=xdata[AY]
        for r in range(1,R+1):
            Nh=np.array([0]) 
            Nh2=np.array([0])
            for h in range(1,H+1):
                XB=XBc[h-1]
                N=XB.shape[0]
                Delta=D[h-1] 
                EP=EPcell[h-1]
                ER=sig*EP[:,:,r-1]
                A=np.identity(N)-alpha*(XB+ER)/N
                s_star= np.matmul(np.linalg.inv(A)*(np.identity(N)-alpha*c*Delta),np.ones((N,1)))
                Nhat=(XB-c*np.divide(Delta,(np.ones((N,1))*np.transpose(s_star)+ER)))*(np.ones((N,N))-np.identity(N))
                Nhat0=np.floor(Nhat) 
                Nhat1=np.minimum(Nhat0,5*np.ones((N,N)))
                Nhat2=Nhat1**2
                NHij=adjpair_dir(Nhat1)
                NH2ij=adjpair_dir(Nhat2)
                Nh=np.concatenate((Nh,NHij))
                Nh2=np.concatenate((Nh2,NH2ij))
            # Start auxiliary regressions 
            Nh=Nh[1:Nh.shape[0]+1]
            Nh2=Nh2[1:Nh2.shape[0]+1]
            NhF=Nh[AY]
            Nh2F=Nh2[AY]
            LM1 = LinearRegression().fit(xdataF,NhF)
            mu11=LM1.coef_
            mu12=np.array([LM1.intercept_])
            mu13=np.array([LM1.score(xdataF,NhF)])
            mu1=np.concatenate((mu12,mu11),axis=0)
            mu1=np.concatenate((mu1,mu13),axis=0)
            LM2 = LinearRegression().fit(xdataF,Nh2F)
            mu23=np.array([LM2.score(xdataF,Nh2F)])
            mut[:,r-1]=np.concatenate((mu1,mu23)) 
        mh=np.mean(mut,axis=1)
        Qn=np.matmul(np.matmul(np.transpose(mh-mu),((1+1/R)**(-1))*WA),mh-mu)
        return Qn
    else:
        return np.inf    

if __name__ == '__main__':

    # Load the data
    with open('spatial_interaction_finaldata_schools4to150.pkl','rb') as f:
        Data=pickle.load(f)
    with open('Xdata_pair_level_Schools4to150.pkl','rb') as f:
        xdata=pickle.load(f)
    with open('P150_st.pkl','rb') as f:
        st=pickle.load(f)
    with open('Wmatrix_Schools4to150.pkl','rb') as f:
        Wresult=pickle.load(f)
    WA=Wresult[0]
    mu=Wresult[1]
    Scell=Data[0]
    SDcell=Data[1]
    Xcell1=Data[2]
    Xcell2=Data[3]
    D=Data[4]
    EPcell=Data[5]
    st_list=Data[6]
    GE=Data[7]
    ADcell=Data[9]
    H=len(Scell)
    X1=[]
    k1=Xcell1[0].shape[2]
    for h in range(1,H+1):
        X1.append(abs(Xcell1[h-1]))
    Xcell=X1
    R=100 
    K=k1*2
    # Start the structural estimation
    theta=scipy.optimize.fmin(socint_obj,st,args=(Xcell,Xcell2,Scell,D,EPcell,mu,WA,xdata,ADcell))
    # Save the parameter estimates
    Result=[theta,socint_obj(theta,Xcell,Xcell2,Scell,D,EPcell,mu,WA,xdata,ADcell)]
    with open('II_Results_Schools4to150.pkl','wb') as f:
        pickle.dump(Result,f)
